--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;


--
-- Name: versionmatch; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

DROP TABLE versionmatch; 

CREATE TABLE versionmatch (
    client_version character varying(16) NOT NULL,
    compatibility integer DEFAULT 0,
    read_only integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.versionmatch OWNER TO postgres;

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY versionmatch (client_version, compatibility, read_only) FROM stdin;
2.5Ak	1	1
\.


--
-- Name: versionmatch_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY versionmatch
    ADD CONSTRAINT versionmatch_pkey PRIMARY KEY (client_version);


--
-- Name: serverinf; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

DROP TABLE serverinf; 

CREATE TABLE serverinf (
    own_url character varying(50),
    system_ipv4_address character varying(50) NOT NULL,
    system_ipv6_address character varying(50),
    ipkts_interface_portno integer,
    imr_interface_portno integer,
    version character varying(16),
    sip_server_type integer DEFAULT 0,
    serverinf_serialkey serial NOT NULL,
    authentication_header integer DEFAULT 0,
    encription integer DEFAULT 0,
    weblink_title character varying(255),
    weblink_url character varying(2000),
    weblink_refresh_interval integer
);


ALTER TABLE public.serverinf OWNER TO postgres;

--
-- Name: serverinf_serverinf_serialkey_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('serverinf', 'serverinf_serialkey'), 3, true);


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY serverinf (own_url, system_ipv4_address, system_ipv6_address, ipkts_interface_portno, imr_interface_portno, version, sip_server_type, serverinf_serialkey, authentication_header, encription, weblink_title, weblink_url, weblink_refresh_interval) FROM stdin;
\N	127.0.0.1	\N	6550	\N	2.5Ak	0	1	1	0	\N	\N	60
\.


--
-- Name: serverinf_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--
ALTER TABLE ONLY serverinf
    ADD CONSTRAINT serverinf_pkey PRIMARY KEY (serverinf_serialkey);


--
-- Name: userinf_userkey_index; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX userinf_userkey_index ON userinf USING btree (user_key);


--
-- Name: private_memberlist_member_index; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX private_memberlist_member_index ON private_memberlist USING btree (member_key);


--
-- Name: private_memberlist_owner_index; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX private_memberlist_owner_index ON private_memberlist USING btree (owner_key);


--
-- PostgreSQL database dump complete
--
